/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer.mojo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javarequirementstracer.JavaRequirementsTracer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class JrtMojo
extends AbstractMojo {
    private static final String REPORTER_PROPERTIES_FILENAME = "/reporter.properties";
    private static final String REPORTER_GROUPID = "reporter.groupid";
    private static final String REPORTER_ARTIFACTID = "reporter.artifactid";
    private static final String REPORTER_VERSION = "reporter.version";
    private static final String REPORTER_SCOPE = "runtime";
    private static final String REPORTER_TYPE = "jar";
    private File paramsFilename;
    private File labelsFilename;
    private File reportFilename;
    private String buildNumber;
    protected MavenProject project;
    private List<String> testClasspathElements;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Maven JRT Plugin");
        this.getLog().info((CharSequence)("Params filename: " + this.paramsFilename));
        this.getLog().info((CharSequence)("Labels filename: " + this.labelsFilename));
        this.getLog().info((CharSequence)("Report filename: " + this.reportFilename));
        this.getLog().info((CharSequence)("Buildnumber: " + this.buildNumber));
        this.getLog().info((CharSequence)("Project basedir: " + this.project.getBasedir()));
        if (this.parametersValid()) {
            ArrayList<URL> classpathUrlList = new ArrayList<URL>();
            classpathUrlList.add(this.getReporterArtifactUrl());
            classpathUrlList.addAll(this.getTestClasspathUrls());
            URLClassLoader classLoader = new URLClassLoader(classpathUrlList.toArray(new URL[0]));
            this.runTracerWithClassloader(classLoader);
        }
    }

    private boolean parametersValid() {
        File paramFile = this.paramsFilename;
        if (paramFile == null) {
            paramFile = new File(this.project.getBasedir() + "/" + "src/main/config/traceability_params.properties");
        }
        if (!paramFile.exists()) {
            this.getLog().info((CharSequence)("Skipping traceability. No params file '" + paramFile.getAbsolutePath() + "' found."));
            return false;
        }
        return true;
    }

    private void runTracerWithClassloader(ClassLoader classLoader) throws MojoExecutionException {
        try {
            Class<?> tracerClass = classLoader.loadClass(JavaRequirementsTracer.class.getName());
            Object tracerInstance = tracerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method setClassLoaderMethod = tracerClass.getDeclaredMethod("setClassLoader", ClassLoader.class);
            setClassLoaderMethod.invoke(tracerInstance, classLoader);
            this.invokeFileSetter(tracerInstance, "setBaseDir", this.project.getBasedir());
            this.invokeStringSetter(tracerInstance, "setParamsFilename", this.paramsFilename);
            this.invokeStringSetter(tracerInstance, "setExpectedLabelsFilename", this.labelsFilename);
            this.invokeStringSetter(tracerInstance, "setReportFileName", this.reportFilename);
            this.invokeStringSetter(tracerInstance, "setBuildNumber", this.buildNumber);
            Method runMethod = tracerClass.getDeclaredMethod("run", new Class[0]);
            runMethod.invoke(tracerInstance, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load " + JavaRequirementsTracer.class.getName() + " from the alternate classloader.", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Could not find constructor of " + JavaRequirementsTracer.class.getName() + ".", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Could not find invoke constructor of " + JavaRequirementsTracer.class.getName() + ".", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Could not access constructor of " + JavaRequirementsTracer.class.getName() + ".", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Could not create instance of " + JavaRequirementsTracer.class.getName() + ".", (Exception)e);
        }
    }

    private void invokeFileSetter(Object instance, String methodName, File fileValue) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method fileSetterMethod = instance.getClass().getDeclaredMethod(methodName, File.class);
        fileSetterMethod.invoke(instance, fileValue);
    }

    private void invokeStringSetter(Object instance, String methodName, File fileValue) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (fileValue != null) {
            this.invokeStringSetter(instance, methodName, fileValue.getAbsolutePath());
        }
    }

    private void invokeStringSetter(Object instance, String methodName, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (value != null) {
            Method stringSetterMethod = instance.getClass().getDeclaredMethod(methodName, String.class);
            stringSetterMethod.invoke(instance, value);
        }
    }

    private List<URL> getTestClasspathUrls() throws MojoExecutionException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String testClasspath : this.testClasspathElements) {
            URL url = this.pathToUrl(testClasspath);
            urlList.add(url);
        }
        return urlList;
    }

    private URL pathToUrl(String path) throws MojoExecutionException {
        try {
            File file = new File(path);
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL: " + path, (Exception)e);
        }
    }

    private URL getReporterArtifactUrl() throws MojoExecutionException {
        InputStream propertiesStream = ((Object)((Object)this)).getClass().getResourceAsStream(REPORTER_PROPERTIES_FILENAME);
        if (propertiesStream == null) {
            throw new MojoExecutionException("Cannot find properties file: /reporter.properties");
        }
        Properties reporterProperties = new Properties();
        try {
            reporterProperties.load(propertiesStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load properties from file: /reporter.properties", (Exception)e);
        }
        Artifact reporterArtifact = this.artifactFactory.createArtifact(reporterProperties.getProperty(REPORTER_GROUPID), reporterProperties.getProperty(REPORTER_ARTIFACTID), reporterProperties.getProperty(REPORTER_VERSION), REPORTER_SCOPE, REPORTER_TYPE);
        URL url = this.pathToUrl(this.localRepository.getBasedir() + "/" + this.localRepository.pathOf(reporterArtifact));
        this.getLog().info((CharSequence)("Reporter URL dependency: " + url.toString()));
        return url;
    }
}

