/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer.mojo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javarequirementstracer.JavaRequirementsTracerBean;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JrtMojo
extends AbstractMojo {
    private static final String REPORTER_PROPERTIES_FILENAME = "/reporter.properties";
    private static final String REPORTER_GROUPID = "reporter.groupid";
    private static final String REPORTER_ARTIFACTID = "reporter.artifactid";
    private static final String REPORTER_VERSION = "reporter.version";
    private static final String REPORTER_SCOPE = "runtime";
    private static final String REPORTER_TYPE = "jar";
    private File paramsFilename;
    private File labelsFilename;
    private File reportFilename;
    private String buildNumber;
    private MavenProject project;
    private List<String> testClasspathElements;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder mavenProjectBuilder;
    private List remoteRepos;
    protected ArtifactResolver artifactResolver;

    public final void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Maven JRT Plugin");
        this.getLog().info((CharSequence)("Params filename: " + this.paramsFilename));
        this.getLog().info((CharSequence)("Labels filename: " + this.labelsFilename));
        this.getLog().info((CharSequence)("Report filename: " + this.reportFilename));
        this.getLog().info((CharSequence)("Buildnumber: " + this.buildNumber));
        this.getLog().info((CharSequence)("Project basedir: " + this.project.getBasedir()));
        if (this.parametersValid()) {
            ArrayList<URL> classpathUrlList = new ArrayList<URL>();
            classpathUrlList.addAll(this.getReporterArtifactUrls());
            classpathUrlList.addAll(this.getTestClasspathUrls());
            URLClassLoader classLoader = new URLClassLoader(classpathUrlList.toArray(new URL[classpathUrlList.size()]));
            this.runTracerWithClassloader(classLoader);
        }
    }

    private boolean parametersValid() {
        File paramFile = this.paramsFilename;
        if (paramFile == null) {
            paramFile = new File(this.project.getBasedir() + "/" + "src/main/config/traceability_params.properties");
        }
        if (!paramFile.exists()) {
            this.getLog().info((CharSequence)("Skipping traceability. No params file '" + paramFile.getAbsolutePath() + "' found."));
            return false;
        }
        return true;
    }

    private void runTracerWithClassloader(ClassLoader classLoader) throws MojoExecutionException {
        try {
            Class<?> tracerClass = classLoader.loadClass(JavaRequirementsTracerBean.class.getName());
            Object tracerInstance = tracerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method setClassLoaderMethod = tracerClass.getDeclaredMethod("setClassLoader", ClassLoader.class);
            setClassLoaderMethod.invoke(tracerInstance, classLoader);
            this.invokeFileSetter(tracerInstance, "setBaseDir", this.project.getBasedir());
            this.invokeStringSetter(tracerInstance, "setParamsFilename", this.paramsFilename);
            this.invokeStringSetter(tracerInstance, "setExpectedLabelsFilename", this.labelsFilename);
            this.invokeStringSetter(tracerInstance, "setReportFileName", this.reportFilename);
            this.invokeStringSetter(tracerInstance, "setBuildNumber", this.buildNumber);
            Method runMethod = tracerClass.getDeclaredMethod("run", new Class[0]);
            runMethod.invoke(tracerInstance, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load " + JavaRequirementsTracerBean.class.getName() + " from the alternate classloader.", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Could not find constructor of " + JavaRequirementsTracerBean.class.getName() + ".", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Could not find invoke constructor of " + JavaRequirementsTracerBean.class.getName() + ".", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Could not access constructor of " + JavaRequirementsTracerBean.class.getName() + ".", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Could not create instance of " + JavaRequirementsTracerBean.class.getName() + ".", (Exception)e);
        }
    }

    private void invokeFileSetter(Object instance, String methodName, File fileValue) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method fileSetterMethod = instance.getClass().getDeclaredMethod(methodName, File.class);
        fileSetterMethod.invoke(instance, fileValue);
    }

    private void invokeStringSetter(Object instance, String methodName, File fileValue) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (fileValue != null) {
            this.invokeStringSetter(instance, methodName, fileValue.getAbsolutePath());
        }
    }

    private void invokeStringSetter(Object instance, String methodName, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (value != null) {
            Method stringSetterMethod = instance.getClass().getDeclaredMethod(methodName, String.class);
            stringSetterMethod.invoke(instance, value);
        }
    }

    private List<URL> getTestClasspathUrls() throws MojoExecutionException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String testClasspath : this.testClasspathElements) {
            URL url = this.pathToUrl(testClasspath);
            urlList.add(url);
        }
        return urlList;
    }

    private URL pathToUrl(String path) throws MojoExecutionException {
        try {
            File file = new File(path);
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid URL: " + path, (Exception)e);
        }
    }

    private List<URL> getReporterArtifactUrls() throws MojoExecutionException {
        Artifact reporterArtifact = this.getReporterArtifact();
        Set<Artifact> dependenciesArtifacts = this.resolveDependencyArtifacts(reporterArtifact);
        HashSet<Artifact> allArtifacts = new HashSet<Artifact>();
        allArtifacts.add(reporterArtifact);
        allArtifacts.addAll(dependenciesArtifacts);
        return this.convertArtifactsIntoUrls(allArtifacts);
    }

    private List<URL> convertArtifactsIntoUrls(Set<Artifact> artifactSet) throws MojoExecutionException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (Artifact artifact : artifactSet) {
            URL url = this.pathToUrl(this.localRepository.getBasedir() + "/" + this.localRepository.pathOf(artifact));
            urlList.add(url);
            this.getLog().info((CharSequence)("Reporter URL: " + url.toString()));
        }
        return urlList;
    }

    private Artifact getReporterArtifact() throws MojoExecutionException {
        InputStream propertiesStream = JrtMojo.class.getResourceAsStream(REPORTER_PROPERTIES_FILENAME);
        if (propertiesStream == null) {
            throw new MojoExecutionException("Cannot find properties file: /reporter.properties");
        }
        Properties reporterProperties = new Properties();
        try {
            reporterProperties.load(propertiesStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load properties from file: /reporter.properties", (Exception)e);
        }
        return this.artifactFactory.createArtifact(reporterProperties.getProperty(REPORTER_GROUPID), reporterProperties.getProperty(REPORTER_ARTIFACTID), reporterProperties.getProperty(REPORTER_VERSION), REPORTER_SCOPE, REPORTER_TYPE);
    }

    private Set<Artifact> resolveDependencyArtifacts(Artifact artifact) throws MojoExecutionException {
        HashSet<Artifact> nonOptionalDependencies = new HashSet<Artifact>();
        try {
            MavenProject project = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepos, this.localRepository);
            Set dependencyArtifacts = project.createArtifacts(this.artifactFactory, REPORTER_SCOPE, (ArtifactFilter)new ScopeArtifactFilter(REPORTER_SCOPE));
            HashSet<Artifact> transitiveDependencies = new HashSet<Artifact>();
            for (Artifact dependencyArtifact : dependencyArtifacts) {
                if (dependencyArtifact.isOptional()) continue;
                this.artifactResolver.resolve(dependencyArtifact, this.remoteRepos, this.localRepository);
                nonOptionalDependencies.add(dependencyArtifact);
                transitiveDependencies.addAll(this.resolveDependencyArtifacts(dependencyArtifact));
            }
            nonOptionalDependencies.addAll(transitiveDependencies);
            return nonOptionalDependencies;
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not resolve dependencies for reporter artifact.", (Exception)((Object)e));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Invalid dependency version.", (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Problem resolving artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Artifact not found.", (Exception)((Object)e));
        }
    }
}

