/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer.systemtest;

import java.io.IOException;
import java.util.Properties;

import javarequirementstracer.FileUtils;
import javarequirementstracer.JavaRequirementsTracerBean;


/**
 * @author Ronald Koster
 */
class STHelper {

	private STHelper() {
		// Util class.
	}
	
	static String createReport(String paramsFilename) throws IOException {
		JavaRequirementsTracerBean tracer = new JavaRequirementsTracerBean();
		tracer.setParamsFilename(paramsFilename);
		tracer.setBuildNumber(getBuildNumber());
		tracer.run();
		return FileUtils.readFileAsString(tracer.getReportFilename());
	}
	
	static String getBuildNumber() throws IOException {
		Properties props = new Properties();
		props.load(STHelper.class.getResourceAsStream("/jrt-reporter.properties"));
		String version = props.getProperty("version");
		int index = version.indexOf('_');
		return version.substring(index + 1);
	}
}